import pytest

import homcloud.int_reduction as int_reduction


@pytest.mark.parametrize(
    ("dim, dic, expected"),
    [
        (0, {"type": "simplicial", "map": [[0, []], [0, []]]}, [[], []]),
        (1, {"type": "simplicial", "map": [[0, []], [0, []], [1, [0, 1]]]}, [[], [], [1, -1]]),
        (0, {"type": "simplicial", "map": []}, []),
        (
            3,
            {
                "type": "simplicial",
                "map": [
                    [0, []],
                    [0, []],
                    [0, []],
                    [0, []],
                    [1, [1, 0]],
                    [1, [3, 1]],
                    [1, [3, 0]],
                    [1, [3, 2]],
                    [1, [1, 2]],
                    [1, [0, 2]],
                    [2, [5, 6, 4]],
                    [2, [5, 7, 8]],
                    [2, [4, 8, 9]],
                    [2, [6, 7, 9]],
                    [3, [10, 11, 13, 12]],
                ],
            },
            [
                [],
                [],
                [],
                [],
                [-1, 1, 0, 0],
                [0, -1, 0, 1],
                [-1, 0, 0, 1],
                [0, 0, -1, 1],
                [0, 1, -1, 0],
                [1, 0, -1, 0],
                [1, 1, -1, 0, 0, 0],
                [0, 1, 0, -1, 1, 0],
                [1, 0, 0, 0, -1, 1],
                [0, 0, 1, -1, 0, 1],
                [1, -1, -1, 1],
            ],
        ),
        (0, {"type": "cubical", "map": []}, []),
        (0, {"type": "cubical", "map": [[0, []], [0, []]]}, [[], []]),
        (
            2,
            {
                "type": "cubical",
                "map": [
                    [0, []],
                    [0, []],
                    [1, [1, 0]],
                    [0, []],
                    [0, []],
                    [1, [0, 4]],
                    [1, [3, 4]],  # 0-6
                    [0, []],
                    [1, [7, 0]],
                    [1, [7, 3]],
                    [2, [9, 5, 8, 6]],  # 7-10
                    [0, []],
                    [1, [11, 1]],
                    [1, [11, 7]],
                    [2, [13, 2, 12, 8]],  # 11-14
                ],
            },
            [
                [],
                [],
                [-1, 1, 0, 0, 0, 0],
                [],
                [],  # 0-4
                [1, 0, 0, -1, 0, 0],
                [0, 0, 1, -1, 0, 0],  # 5-6
                [],
                [-1, 0, 0, 0, 1, 0],
                [0, 0, -1, 0, 1, 0],  # 7-9
                [0, -1, 1, -1, 1, 0, 0],  # 10
                [],
                [0, -1, 0, 0, 0, 1],
                [0, 0, 0, 0, -1, 1],  # 11-13
                [-1, 0, 0, 1, 0, -1, 1],  # 14
            ],
        ),
        (0, {"type": "abstract", "map": []}, []),
        (0, {"type": "abstract", "map": [[0, [], []], [0, [], []]]}, [[], []]),
        (
            1,
            {"type": "abstract", "map": [[0, [], []], [0, [], []], [0, [], []], [1, [2, 0], [-1, 1]]]},
            [[], [], [], [1, 0, -1]],
        ),
    ],
)
def test_build_checker(dim, dic, expected):
    checker = int_reduction.build_checker(dim, dic)
    for k in range(len(dic["map"])):
        assert checker.column(k) == expected[k]
