import pytest
import numpy as np
import homcloud.graph_optimal_one_cycle as graph_opt1cyc


@pytest.mark.parametrize(
    "matrix, birth, weighted, result",
    [
        (
            np.array(
                [
                    [0, 1.2, 1.7],
                    [1.2, 0, 1.9],
                    [1.7, 1.9, 0],
                ]
            ),
            1.9,
            False,
            [2, 0, 1],
        ),
        (
            np.array(
                [
                    [0.0, 1.1, 1.5, 1.4],
                    [1.1, 0.0, 1.2, 1.6],
                    [1.5, 1.2, 0.0, 1.3],
                    [1.4, 1.6, 1.3, 0.0],
                ]
            ),
            1.4,
            False,
            [3, 2, 1, 0],
        ),
        (
            np.array(
                [
                    [0.0, 1.1, 1.5, 1.4],
                    [1.1, 0.0, 1.2, 1.6],
                    [1.5, 1.2, 0.0, 1.3],
                    [1.4, 1.6, 1.3, 0.0],
                ]
            ),
            1.4,
            True,
            [3, 2, 1, 0],
        ),
        (
            np.array(
                [
                    [0.0, 1.1, 1.5, 1.4],
                    [1.1, 0.0, 1.2, 1.6],
                    [1.5, 1.2, 0.0, 1.3],
                    [1.4, 1.6, 1.3, 0.0],
                ]
            ),
            1.6,
            True,
            [3, 0, 1],
        ),
        (
            np.array(
                [
                    [0.0, 1.2, 2.1, 2.0, 1.8],
                    [1.2, 0.0, 1.3, 2.2, 2.3],
                    [2.1, 1.3, 0.0, 1.0, 2.6],
                    [2.0, 2.2, 1.0, 0.0, 1.9],
                    [1.8, 2.3, 2.6, 1.9, 0.0],
                ]
            ),
            2.0,
            False,
            [3, 4, 0],
        ),
        (
            np.array(
                [
                    [0.0, 1.2, 2.1, 2.0, 1.8],
                    [1.2, 0.0, 1.3, 2.2, 2.3],
                    [2.1, 1.3, 0.0, 1.0, 2.6],
                    [2.0, 2.2, 1.0, 0.0, 1.9],
                    [1.8, 2.3, 2.6, 1.9, 0.0],
                ]
            ),
            2.0,
            True,
            [3, 2, 1, 0],
        ),
    ],
)
def test_search(matrix, birth, weighted, result):
    assert graph_opt1cyc.search(matrix, birth, weighted) == result


@pytest.mark.parametrize(
    "matrix, birth, cocycle, epsilon, result",
    [
        (
            np.array(
                [
                    [0.0, 1.2, 2.1, 2.0, 1.8],
                    [1.2, 0.0, 1.3, 2.2, 2.3],
                    [2.1, 1.3, 0.0, 1.0, 2.6],
                    [2.0, 2.2, 1.0, 0.0, 1.9],
                    [1.8, 2.3, 2.6, 1.9, 0.0],
                ]
            ),
            2.0,
            [[3, 0, 1]],
            0.0,
            [3, 2, 1, 0],
        ),
        (
            np.array(
                [
                    [0.0, 1.2, 2.1, 2.0, 1.8],
                    [1.2, 0.0, 1.3, 2.2, 2.3],
                    [2.1, 1.3, 0.0, 1.0, 2.6],
                    [2.0, 2.2, 1.0, 0.0, 1.9],
                    [1.8, 2.3, 2.6, 1.9, 0.0],
                ]
            ),
            2.0,
            [[3, 0, 1]],
            1.0,
            [3, 2, 0],
        ),
        (
            np.array(
                [
                    [0.0, 1.2, 2.1, 2.0, 1.8],
                    [1.2, 0.0, 1.3, 2.2, 2.3],
                    [2.1, 1.3, 0.0, 1.0, 2.6],
                    [2.0, 2.2, 1.0, 0.0, 1.9],
                    [1.8, 2.3, 2.6, 1.9, 0.0],
                ]
            ),
            2.0,
            [[0, 2, 1], [3, 0, 1]],
            0.05,
            [3, 2, 1, 0],
        ),
        (
            np.array(
                [
                    [0.0, 1.2, 2.1, 2.0, 1.8],
                    [1.2, 0.0, 1.3, 2.2, 2.3],
                    [2.1, 1.3, 0.0, 1.0, 2.6],
                    [2.0, 2.2, 1.0, 0.0, 1.9],
                    [1.8, 2.3, 2.6, 1.9, 0.0],
                ]
            ),
            2.0,
            [[0, 2, 1], [3, 0, 1]],
            0.11,
            [2, 1, 0],
        ),
    ],
)
def test_search_with_cocycle(matrix, birth, cocycle, epsilon, result):
    assert graph_opt1cyc.search_with_cocycle(matrix, cocycle, birth, epsilon, True) == result
